package com.bizvane.openapi.common.exception;

import com.bizvane.openapi.common.consts.CodeMessageConsts;
import com.bizvane.openapi.common.response.CodeMessage;
import jdk.internal.dynalink.beans.StaticClass;

import java.util.Optional;
import java.util.function.Supplier;

/**
 * @author wang.zeyan 2019/07/15
 */
public class OpenApiExceptionSupplier implements Supplier<OpenApiException> {


    CodeMessage codeMessage = null;

    OpenApiExceptionSupplier(CodeMessage codeMessage) {
        this.codeMessage = codeMessage;
    }

    @Override
    public OpenApiException get() {
        return new OpenApiException(codeMessage);
    }

    public static OpenApiExceptionSupplier convert(CodeMessage codeMessage) {
        return new OpenApiExceptionSupplier(Optional.ofNullable(codeMessage).orElseGet(() -> CodeMessageConsts.Base.CODE_MESSAGE_EMPTY));
    }
}
