package com.bizvane.openapi.common.exception;

import org.apache.commons.lang3.exception.ExceptionUtils;

import com.bizvane.openapi.common.response.CodeMessage;
import org.springframework.web.server.ResponseStatusException;

/**
 * @author wang.zeyan
 * 2019年4月11日
 */
public class OpenApiException extends ResponseStatusException {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    private CodeMessage codeMessage;

	/*@SuppressWarnings("unused")
	private OpenApiException() {

	}

	private OpenApiException(String message) {
		super(message);
	}*/

    public OpenApiException(CodeMessage codeMessage) {
        super(codeMessage.getCode(), codeMessage.getMsg());
        this.codeMessage = codeMessage;
        //this(codeMessage.toString());
        //this.setCodeMessage(codeMessage);
    }

    public OpenApiException(CodeMessage codeMessage, Throwable cause) {
        //super(codeMessage.toString(), cause);
        super(codeMessage.getCode(), codeMessage.getMsg(), cause);
        this.codeMessage = codeMessage;
        //this.setCodeMessage(codeMessage);
    }

    public CodeMessage getCodeMessage() {
        return codeMessage;
    }

    private void setCodeMessage(CodeMessage codeMessage) {
        this.codeMessage = codeMessage;
    }

    public static OpenApiException newInstance(CodeMessage codeMessage) {
        return new OpenApiException(codeMessage);
    }

    public static OpenApiException newInstance(CodeMessage codeMessage, Throwable cause) {
        return new OpenApiException(codeMessage, cause);
    }

    public static OpenApiException newInstanceWithRootCause(CodeMessage codeMessage, Throwable cause) {
        CodeMessage cm = CodeMessage.newInstance(codeMessage.getCode(), codeMessage.getMsg());
        cm.setMsg(String.format("%s[%s]", cm.getMsg(), ExceptionUtils.getRootCauseMessage(cause)));
        return new OpenApiException(cm, cause);
    }
}
