package com.bizvane.openapi.common.consts;

import com.bizvane.openapi.common.response.CodeMessage;

/**
 * 
 * @author wang.zeyan
 *  2019年4月11日
 */
public interface CodeMessageConsts {
	
	
	
	
	/**
	 * @author wang.zeyan
	 *  2019年4月11日
	 */
	public static interface Base extends CodeConsts {
		String DEFAULT_SUCCESS_MESSAGE = "Success";
		String DEFAULT_FAIL_MESSAGE = "Unknown";
		CodeMessage SUCCESS = CodeMessage.newInstance(CodeConsts.SUCCESS, DEFAULT_SUCCESS_MESSAGE);
		CodeMessage UNKNOWN = CodeMessage.newInstance(CodeConsts.SERVER_ERROR, DEFAULT_FAIL_MESSAGE);
		CodeMessage ID_EMPTY = CodeMessage.newInstance(CodeConsts.CLIENT_ERROR, "Empty.Id");
		CodeMessage CODE_MESSAGE_EMPTY = CodeMessage.newServerInstance("Empty.CodeMessage");
	}
	/**
	 *
	 * @author wang.zeyan
	 *  2019年4月11日
	 */
	public static interface Network extends CodeConsts {
		CodeMessage NETWORK_ERROR = CodeMessage.newInstance(CodeConsts.SERVER_ERROR, "Network.Exception");
		CodeMessage NETWORK_REQUEST_ERROR = CodeMessage.newInstance(CodeConsts.SERVER_ERROR, "Api.Request.Exception", "API请求异常");
		CodeMessage NETWORK_HTTP_NOT_FOUND = CodeMessage.newServerInstance("Api.Request.NotFound", "API请求地址不存在");
	}
	
	/**
	 * 请求转发 Forward the request
	 * @author wang.zeyan
	 *  2019年4月11日
	 */
	public static interface Forward extends CodeConsts {
		CodeMessage HTTP_REQUEST_METHOD_EMPTY = CodeMessage.newInstance(CodeConsts.SERVER_ERROR, "Empty.Request.Method");
		CodeMessage HTTP_REQUEST_URL_EMPTY = CodeMessage.newInstance(CodeConsts.SERVER_ERROR, "Empty.Request.Url");
		CodeMessage HTTP_REQUEST_RESULT_CLASS_EMPTY = CodeMessage.newInstance(CodeConsts.SERVER_ERROR, "Empty.Request.ResultClass");
	}

	/**
	 * 保护限制
	 * @author wang.zeyan
	 * 2019.06.28
	 */
	public static interface Limit extends CodeConsts {
		CodeMessage FLOW_LIMIT = CodeMessage.newInstance(CodeConsts.LIMIT, "Limit.Flow", "流量限制");
		CodeMessage FLOW_QPS_LIMIT = CodeMessage.newInstance(CodeConsts.LIMIT, "Limit.Flow.QPS", "流量QPS限制");
		CodeMessage FLOW_THREAD_LIMIT = CodeMessage.newInstance(CodeConsts.LIMIT, "Limit.Flow.Thread", "流量线程限制");

		CodeMessage DEGRADE_LIMIT = CodeMessage.newInstance(CodeConsts.LIMIT,"Limit.Degrade", "熔断限制");

		CodeMessage AUTHORITY_LIMIT = CodeMessage.newInstance(CodeConsts.FORBIDDEN,"Limit.Authority", "黑白名单限制");
		CodeMessage AUTHORITY_WHITE_LIMIT = CodeMessage.newInstance(CodeConsts.FORBIDDEN,"Limit.Authority.White", "白名单限制");
		CodeMessage AUTHORITY_BLACK_LIMIT = CodeMessage.newInstance(CodeConsts.FORBIDDEN,"Limit.Authority.Black", "黑名单限制");

		CodeMessage SYSTEM_LIMIT = CodeMessage.newInstance(CodeConsts.LIMIT,"Limit.System.{LimitApp}", "系统保护限制");
		CodeMessage SYSTEM_LIMIT_QPS = CodeMessage.newInstance(CodeConsts.LIMIT,"Limit.System.qps", "系统保护QPS限制");
		CodeMessage SYSTEM_LIMIT_THREAD = CodeMessage.newInstance(CodeConsts.LIMIT,"Limit.System.thread", "系统保护线程限制");
		CodeMessage SYSTEM_LIMIT_RT = CodeMessage.newInstance(CodeConsts.LIMIT,"Limit.System.rt", "系统保护平均耗时限制");
		CodeMessage SYSTEM_LIMIT_LOAD = CodeMessage.newInstance(CodeConsts.LIMIT,"Limit.System.load", "系统保护系统负载限制");
		CodeMessage SYSTEM_LIMIT_CPU = CodeMessage.newInstance(CodeConsts.LIMIT,"Limit.System.cpu", "系统保护CPU限制");
	}
 	
}
