package com.bizvane.openapi.common.consts;

import com.bizvane.openapi.common.response.CodeMessage;
import org.springframework.http.HttpStatus;

import static com.bizvane.openapi.common.response.CodeMessage.newClientInstance;
import static com.bizvane.openapi.common.response.CodeMessage.newInstance;

/**
 * @author wang.zeyan
 * 2019年5月21日
 */
public interface CodeConsts {

    /**
     * 客户端错误 CLIENT_ERROR = 400
     */
    HttpStatus CLIENT_ERROR = HttpStatus.BAD_REQUEST;
    /**
     * 资源未找到
     */
    //int NOT_FOUND = 404;
    HttpStatus NOT_FOUND = HttpStatus.NOT_FOUND;
    /**
     * 服务端错误
     */
    //int SERVER_ERROR = 500;
    HttpStatus SERVER_ERROR = HttpStatus.INTERNAL_SERVER_ERROR;
    /**
     * 禁止访问(黑白名单)
     */
    //int FORBIDDEN = 403;
    HttpStatus FORBIDDEN = HttpStatus.FORBIDDEN;
    /**
     * URI请求限制
     */
    //int LIMIT = 429;
    HttpStatus LIMIT = HttpStatus.TOO_MANY_REQUESTS;

    /**
     * 成功
     */
    //int SUCCESS = 200;
    HttpStatus SUCCESS = HttpStatus.OK;

    CodeMessage MISSING_PARAMETER_NAME = newClientInstance("Missing.{ParameterName}", "缺少必选参数{ParameterName}");
    CodeMessage DUPLICATE_PARAMETER_NAME = newClientInstance("Duplicate.{ParameterName}", "重复的{ParameterName}");
    CodeMessage MISMATCH_PARAMETER_NAME = newClientInstance("Mismatch.{ParameterName}", "参数{ParameterName}不匹配");

    CodeMessage INVALID_RESOURCE_NOT_FOUND = newInstance(CodeConsts.NOT_FOUND, "Invalid{Resource}.NotFound", "无效的资源,资源不存在");
    CodeMessage RESOURCE_PERMISSION_DENIED = newClientInstance("Resource.PermissionDenied", "资源权限无效");
}
