package com.bizvane.openapi.common.cache.redis;

import java.time.Duration;
import java.util.Map;

import org.springframework.boot.context.properties.ConfigurationProperties;

import com.google.common.collect.Maps;

/**
 * 
 * @author wang.zeyan
 *  2019年4月16日
 */
@ConfigurationProperties(prefix = "spring.cache.redis")
public class CustomRedisCacheProperties {

	private Map<String, RedisProperties> caches = Maps.newHashMap();
	
	/**
	 * cache global ttl
	 */
	private Duration ttl = Duration.ZERO;

	public Map<String, RedisProperties> getCaches() {
		return caches;
	}

	public void setCaches(Map<String, RedisProperties> caches) {
		this.caches = caches;
	}

	public Duration getTtl() {
		return ttl;
	}

	public void setTtl(Duration ttl) {
		this.ttl = ttl;
	}
}
