package com.bizvane.openapi.common.cache.codec;

import java.io.IOException;

import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;

/**
 * 
 * @author wang.zeyan
 *  2019年4月26日
 */
public class FastjsonCodec extends BaseCodec {

	static {
		ParserConfig.getGlobalInstance().setAutoTypeSupport(true); 
	}
	
	public FastjsonCodec() {
		super();
	}

	public static final FastjsonCodec INSTANCE = new FastjsonCodec();
	
	private final Encoder encoder = new Encoder() {
        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream os = new ByteBufOutputStream(out);
                JSON.writeJSONString(os, in, SerializerFeature.WriteClassName);
                return os.buffer();
            } catch (IOException e) {
                throw e;
            } catch (Exception e) {
                throw new IOException(e);
            } finally {
            	out.release();
			}
        }
    };
    
    private final Decoder<Object> decoder = new Decoder<Object>() {
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
        	return JSON.parseObject(new ByteBufInputStream(buf), Object.class);
        }
    };
	
    public FastjsonCodec(ClassLoader classLoader) {
    	this();
    }

    public FastjsonCodec(ClassLoader classLoader, FastjsonCodec codec) {
        this();
    }
	
	@Override
	public Decoder<Object> getValueDecoder() {
		return decoder;
	}

	@Override
	public Encoder getValueEncoder() {
		return encoder;
	}

}
