/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.business.modules.business.service.impl;

import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.openapi.business.consts.CodeMessageConsts;
import com.bizvane.openapi.business.modules.business.entity.OpenapiBusinessMain;
import com.bizvane.openapi.business.modules.business.mapper.OpenapiBusinessMainMapper;
import com.bizvane.openapi.business.modules.business.service.OpenapiBusinessMainService;
import com.bizvane.openapi.common.consts.CodeConsts;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class OpenapiBusinessMainServiceImpl
extends ServiceImpl<OpenapiBusinessMainMapper, OpenapiBusinessMain>
implements OpenapiBusinessMainService {
    @Autowired
    PasswordEncoder passwordEncoder;
    private Consumer<OpenapiBusinessMain> accountValid = s -> Assert.missing((String)s.getAccount(), (String[])new String[]{"Account"});
    private Consumer<OpenapiBusinessMain> passwordValid = s -> Assert.missing((String)s.getPassword(), (String[])new String[]{"Password"});
    private Consumer<OpenapiBusinessMain> businessIdValid = s -> Assert.missing((String)s.getId(), (String[])new String[]{"BusinessId"});
    private Consumer<OpenapiBusinessMain> entityValid = e -> Assert.notNull((Object)e, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);

    @Override
    @SqlParser(filter=true)
    public OpenapiBusinessMain login(String account, String password) {
        Assert.missing((String)account, (String[])new String[]{"Account"});
        Assert.missing((String)password, (String[])new String[]{"Password"});
        OpenapiBusinessMain entity = (OpenapiBusinessMain)this.getOne((Wrapper)new QueryWrapper().eq((Object)"account", (Object)account), true);
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.INVALID_ACCOUNT);
        Assert.isTrue((boolean)this.passwordEncoder.matches((CharSequence)password, entity.getPassword()), (CodeMessage)CodeMessageConsts.Business.WRONG_PASSWORD);
        entity.setPassword(null);
        return entity;
    }

    public boolean save(OpenapiBusinessMain entity) {
        this.entityValid.andThen(this.accountValid).andThen(this.passwordValid).andThen(this.businessIdValid).accept(entity);
        OpenapiBusinessMain byId = (OpenapiBusinessMain)this.getById((Serializable)((Object)entity.getId()));
        Assert.isNull((Object)byId, (CodeMessage)CodeMessage.newInstance((CodeMessage)CodeConsts.DUPLICATE_PARAMETER_NAME, (String[])new String[]{"BusinessId"}));
        Date now = new Date();
        entity.setPassword(this.passwordEncoder.encode((CharSequence)entity.getPassword())).setCreateTime(now).setModifyTime(now).setStatus(0);
        return super.save((Object)entity);
    }

    @Override
    public boolean updateByAccount(OpenapiBusinessMain entity, String account) {
        Optional.ofNullable(entity).ifPresent(u -> {
            OpenapiBusinessMain openapiBusinessMain = u.setAccount(account);
        });
        return this.updateByAccount(entity);
    }

    @Override
    public boolean updateByAccount(OpenapiBusinessMain entity) {
        this.entityValid.andThen(this.accountValid).accept(entity);
        OpenapiBusinessMain one = (OpenapiBusinessMain)this.getOne((Wrapper)new QueryWrapper().eq((Object)"account", (Object)entity.getAccount()));
        Assert.notNull((Object)one, (CodeMessage)CodeMessageConsts.Business.INVALID_BUSINESS);
        return this.update(entity, (Wrapper<OpenapiBusinessMain>)((Wrapper)new UpdateWrapper().eq((Object)"account", (Object)entity.getAccount())));
    }

    public boolean update(OpenapiBusinessMain entity, Wrapper<OpenapiBusinessMain> updateWrapper) {
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        Optional.ofNullable(entity.getPassword()).ifPresent(u -> {
            OpenapiBusinessMain openapiBusinessMain2 = entity.setPassword(this.passwordEncoder.encode((CharSequence)u));
        });
        entity.setCreateTime(null).setModifyTime(new Date());
        return super.update((Object)entity, updateWrapper);
    }
}

