package com.bizvane.openapi.business.modules.test.service.impl;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.openapi.business.consts.CodeMessageConsts.Api;
import com.bizvane.openapi.business.consts.CodeMessageConsts.Business;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiManager;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApi;
import com.bizvane.openapi.business.modules.test.mapper.OpenapiTestApiMapper;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.utils.Assert;

/**
 * 
 * @author wang.zeyan
 *  2019年4月26日
 */
@Service
public class OpenapiTestApiServiceImpl extends ServiceImpl<OpenapiTestApiMapper, OpenapiTestApi> implements OpenapiTestApiService {

	@Autowired
	OpenapiApiManager apiService;
	
	@Override
	public boolean save(OpenapiTestApi entity) {
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		Assert.missing(entity.getName(), "Name");
		Assert.hasText(entity.getApiId(), Api.API_ID_EMPTY);

		if(!StringUtils.hasText(entity.getBusinessId())) {
			entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
		}
		Assert.hasText(entity.getBusinessId(), Business.BUSINESS_ID_EMPTY);
		
		OpenapiApiInfo apiInfo = apiService.getApiInfo(entity.getApiId());
		Assert.notInvalidResource(apiInfo, "ApiInfo");
		
		Date now = new Date();
		entity
		.setCreateTime(now)
		.setModifyTime(now)
		.setBusinessId(ThreadBusiness.getCurrentBusinessId())
		.setIsPrimary(false)
		.setId(null);
		return super.save(entity);
	}

	@Override
	public boolean update(OpenapiTestApi entity, Wrapper<OpenapiTestApi> updateWrapper) {
		
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		entity
		.setBusinessId(null)
		.setCreateTime(null)
		.setApiId(null)
		.setModifyTime(new Date());
		return super.update(entity, updateWrapper);
	}
}
