package com.bizvane.openapi.business.modules.test.service.impl;

import com.bizvane.openapi.business.consts.CodeMessageConsts.Business;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApi;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApiRequestParams;
import com.bizvane.openapi.business.modules.test.mapper.OpenapiTestApiRequestParamsMapper;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiRequestParamsService;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.utils.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * <p>
 * 接口测试请求参数 服务实现类
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-26
 */
@Service
public class OpenapiTestApiRequestParamsServiceImpl extends ServiceImpl<OpenapiTestApiRequestParamsMapper, OpenapiTestApiRequestParams> implements OpenapiTestApiRequestParamsService {

	@Autowired
	OpenapiTestApiService testApiRequestService;
	
	@Async
	@Override
	public boolean save(OpenapiTestApiRequestParams entity) {
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		Assert.missing(entity.getName(), "Name");
		Assert.missing(entity.getTestApiId(), "TestApiId");
		
		if(!StringUtils.hasText(entity.getBusinessId())) {
			entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
		}
		Assert.hasText(entity.getBusinessId(), Business.BUSINESS_ID_EMPTY);
		
		OpenapiTestApi testApiRequest = testApiRequestService.getById(entity.getTestApiId());
		Assert.notInvalidResource(testApiRequest, "TestApi");
		
		Date now = new Date();
		entity
		.setBusinessId(ThreadBusiness.getCurrentBusinessId())
		.setCreateTime(now)
		.setModifyTime(now)
		.setId(null);
		return super.save(entity);
	}

	@Override
	public boolean update(OpenapiTestApiRequestParams entity, Wrapper<OpenapiTestApiRequestParams> updateWrapper) {
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		entity
		.setBusinessId(null)
		.setTestApiId(null)
		.setCreateTime(null)
		.setModifyTime(new Date());
		return super.update(entity, updateWrapper);
	}
}
