package com.bizvane.openapi.business.modules.test.service.impl;

import brave.Span;
import brave.Tracer;
import brave.propagation.B3SingleFormat;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.consts.CodeMessageConsts.Api;
import com.bizvane.openapi.business.consts.CodeMessageConsts.Business;
import com.bizvane.openapi.business.consts.StringConsts.ApiParams;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiRequestParams;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiManager;
import com.bizvane.openapi.business.modules.developeraccount.entity.OpenapiDeveloperAccount;
import com.bizvane.openapi.business.modules.developeraccount.service.OpenapiDeveloperAccountManager;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApi;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApiHistory;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApiRequestParams;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiHistoryService;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiManager;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiRequestParamsService;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.business.utils.WrapperUtils;
import com.bizvane.openapi.common.consts.StringConsts;
import com.bizvane.openapi.common.request.HttpRequest;
import com.bizvane.openapi.common.utils.Assert;
import com.bizvane.openapi.common.utils.SignatureUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 
 * @author wang.zeyan
 *  2019年5月9日
 */
@Service
@Slf4j
public class OpenapiTestApiManagerImpl implements OpenapiTestApiManager {
	
	
	@Autowired
	Tracer tracer;


	@Autowired
	HttpRequest request;
	//TODO gateway 去除依赖, 需调整引用


	@Autowired
	OpenapiApiManager apiService;

	@Autowired
	OpenapiTestApiService testApiService;
	
	@Autowired
	OpenapiTestApiHistoryService apiHistoryService;
	
	@Autowired
	OpenapiTestApiHistoryService testApiHistoryService;
	
	@Autowired
	OpenapiTestApiRequestParamsService testApiRequestParamsService;
	
	@Autowired
	OpenapiDeveloperAccountManager developerAccountManager;
	
	@Value("${spring.application.name}")
	String appName;
	
	@Override
	public Object executeTest(String apiId, Map<String, Object> params, String businessId) {
		Assert.missing(apiId, "ApiId");
		OpenapiApiInfo apiInfo = apiService.getApiInfo(apiId);
		Assert.notInvalidResource(apiInfo, "ApiInfo");
		
		Map<String, OpenapiApiRequestParams> apiRequestParamsMap = apiService.getApiRequestParamsMap(apiId);
		Map<String, Object> bodyMap = Maps.newHashMap();
		Map<String, Object> paramsMap = Maps.newHashMap();
		Map<String, Object> headersMap = Maps.newHashMap();
		
		if(!apiRequestParamsMap.isEmpty() && !CollectionUtils.isEmpty(params)) {
			for (Map.Entry<String, OpenapiApiRequestParams> entry : apiRequestParamsMap.entrySet()) {
				String key = entry.getKey();
				Object val = params.get(key);
				if(val == null || !StringUtils.hasText(val.toString())) {
					continue;
				}
				switch (entry.getValue().getRequestType()) {
				case ApiParams.REQUEST_TYPE_HEADER:
					headersMap.put(key, val);
					break;
				case ApiParams.REQUEST_TYPE_PATH:
					break;
				case ApiParams.REQUEST_TYPE_BODY:
					bodyMap.put(key, val);
					break;
				default:
					paramsMap.put(key, val);
					break;
				}
			}
		}
		
		return exec(apiInfo, bodyMap, paramsMap, headersMap, apiId, businessId);
	}
	
	@Override
	public Object executeTest(String testApiId) {
		
		
		Assert.missing(testApiId, "TestApiId");
		
		OpenapiTestApi one = testApiService.getOne(WrapperUtils.getQueryWrapperId(testApiId, OpenapiTestApi.class));
		Assert.notInvalidResource(one, "TestApi");
		OpenapiApiInfo apiInfo = apiService.getApiInfo(one.getApiId());
		Assert.notInvalidResource(apiInfo, "ApiInfo");
		
		Map<String, OpenapiApiRequestParams> apiRequestParamsMap = apiService.getApiRequestParamsMap(one.getApiId());
		
		Map<String, Object> bodyMap = Maps.newHashMap();
		Map<String, Object> paramsMap = Maps.newHashMap();
		Map<String, Object> headersMap = Maps.newHashMap();
		if(!apiRequestParamsMap.isEmpty()) {
			List<OpenapiTestApiRequestParams> testParams = testApiRequestParamsService.list(
					new QueryWrapper<OpenapiTestApiRequestParams>().eq(com.bizvane.openapi.business.consts.StringConsts.TEST_API_ID, testApiId));
			
			if(!CollectionUtils.isEmpty(testParams)) {
				Map<String, OpenapiTestApiRequestParams> testParamsMap = testParams.stream().collect(Collectors.toMap(OpenapiTestApiRequestParams::getName, (p) -> p));
				for (Map.Entry<String, OpenapiApiRequestParams> entry : apiRequestParamsMap.entrySet()) {
					String key = entry.getKey();
					OpenapiTestApiRequestParams testParam = testParamsMap.get(key);
					if(testParam == null || !StringUtils.hasText(testParam.getValue())) {
						continue;
					}
					
					String val = testParam.getValue();
					switch (entry.getValue().getRequestType()) {
					case ApiParams.REQUEST_TYPE_HEADER:
						headersMap.put(key, val);
						break;
					case ApiParams.REQUEST_TYPE_PATH:
						break;
					case ApiParams.REQUEST_TYPE_BODY:
						bodyMap.put(key, val);
						break;
					//query
					default:
						paramsMap.put(key, val);
						break;
					}
				}
			}
		}
		return exec(apiInfo, bodyMap, paramsMap, headersMap, testApiId, null);
	}
	
	static Set<String> signatureHeaders = Sets.newHashSet(StringConsts.SIGNATURE_APP_KEY, StringConsts.SIGNATURE_TIMESTAMP, StringConsts.SIGNATURE_NONCE);
	static String signatureHeadersValue = Joiner.on(',').join(signatureHeaders);
	
	private void secondSignature(Map<String, Object> paramsMap, Map<String, Object> bodyMap, Map<String, Object> headersMap, String providerAppKey, String providerAppSecret, Object requestBusinessId) {
		
		Map<String, Object> signatureHeadersMap = Maps.newHashMap();
		// 参与签名
		signatureHeadersMap.put(StringConsts.SIGNATURE_NONCE, RandomStringUtils.randomAlphabetic(8));
		signatureHeadersMap.put(StringConsts.SIGNATURE_TIMESTAMP, System.currentTimeMillis());
		signatureHeadersMap.put(StringConsts.SIGNATURE_APP_KEY, providerAppKey);
		
		Map<String, Object> params = Maps.newHashMap();
		params.putAll(paramsMap);
		params.putAll(bodyMap);
		params.putAll(signatureHeadersMap);
		
		String signatureWithAppSecret = SignatureUtils.sign(providerAppSecret, params);
		// 不参与签名
		signatureHeadersMap.put(StringConsts.SIGNATURE_HEADERS, signatureHeadersValue);
		signatureHeadersMap.put(StringConsts.REQUEST_BUSINESS_ID, requestBusinessId);
		tracer.startScopedSpan(appName);
		Span span = tracer.currentSpan();
		span.kind(Span.Kind.CLIENT);
		signatureHeadersMap.put(StringConsts.B3, B3SingleFormat.writeB3SingleFormat(span.context()));
		signatureHeadersMap.put(StringConsts.REQUEST_ID, span.context().traceIdString());
		signatureHeadersMap.put(StringConsts.SIGNATURE_SIGNATURE, signatureWithAppSecret);
		
		headersMap.putAll(signatureHeadersMap);
	}
	
	private Object exec(OpenapiApiInfo apiInfo, Map<String, Object> bodyMap, Map<String, Object> paramsMap, Map<String, Object> headersMap, String testApiId, String businessId) {
		log.info("forward | {} | {} | body:{} | query:{} | headers:{}", 
				apiInfo.getMethod(), 
				apiInfo.getUrl(), 
				JSON.toJSONString(bodyMap),
				JSON.toJSONString(paramsMap),
				JSON.toJSONString(headersMap));

		OpenapiDeveloperAccount providerDeveloperAccount = developerAccountManager.getProviderDeveloperAccount(apiInfo.getBusinessId());
		Assert.notNull(providerDeveloperAccount, Business.PROVIDER_NOT_EXIST);


		/**
		 * 请求签名
		 */
		secondSignature(paramsMap, bodyMap, headersMap, providerDeveloperAccount.getAppKey(), providerDeveloperAccount.getAppSecret(), businessId != null ? businessId : apiInfo.getBusinessId());

		Stopwatch stopwatch = Stopwatch.createStarted();
		JSONObject result = null;
		boolean status = true;
		try {
			result = request.request(apiInfo.getMethod().getVal(), apiInfo.getUrl(), bodyMap, paramsMap, headersMap, JSONObject.class);
			return result;
		} catch (Exception e) {
			result = new JSONObject();
			status = false;
			result.put("error", e.getMessage());
			result.put("root cause", ExceptionUtils.getRootCauseMessage(e));
			throw e;
		} finally {
			stopwatch.stop();
			long us = stopwatch.elapsed(TimeUnit.MICROSECONDS);
			log.info("forward | {} | {} | result:{} | cost: {} μs | {}", apiInfo.getMethod(), apiInfo.getUrl(), result, us, stopwatch);
			OpenapiTestApiHistory history = new OpenapiTestApiHistory();
			history.setBusinessId(ThreadBusiness.getCurrentBusinessId());
			history.setTestApiId(testApiId);
			history.setTestCost(us);
			history.setTestResult(JSON.toJSONString(result));
			history.setTestStatus(status);
			history.setTestCostFriendly(stopwatch.toString());
			testApiHistoryService.save(history);
		}
	}

	@Override
	public boolean addTest(OpenapiTestApi entity, String apiId) {
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
		entity.setApiId(apiId);
		return testApiService.save(entity);
	}

	@Override
	public boolean updateTest(OpenapiTestApi entity, String id) {
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		return testApiService.update(entity, WrapperUtils.getUpdateWrapperId(id, OpenapiTestApi.class));
	}

	@Override
	public boolean deleteTestApiRequestParamsByApiId(String apiId) {
		Assert.hasText(apiId, Api.API_ID_EMPTY);
		// TODO 待实现
		return false;
	}

	@Override
	public OpenapiTestApi getTest(String id) {

		return testApiService.getOne(WrapperUtils.getQueryWrapperId(id, OpenapiTestApi.class));
	}

	@Override
	public boolean addTestApiRequestParams(OpenapiTestApiRequestParams entity, String testApiId) {
		
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
		entity.setTestApiId(testApiId);
		return testApiRequestParamsService.save(entity);
	}

	@Override
	public boolean updateTestApiRequestParams(OpenapiTestApiRequestParams entity, String id) {

		return testApiRequestParamsService.update(entity, WrapperUtils.getUpdateWrapperId(id, OpenapiTestApiRequestParams.class));
	}

	@Override
	public List<OpenapiTestApiRequestParams> getTestApiRequestParams(String testApiId) {
		return testApiRequestParamsService.list(new UpdateWrapper<OpenapiTestApiRequestParams>()
				.eq(com.bizvane.openapi.business.consts.StringConsts.TEST_API_ID, testApiId));
	}

	@Override
	public boolean deleteTestApiRequestParams(String id) {
		return testApiRequestParamsService.remove(WrapperUtils.getQueryWrapperId(id, OpenapiTestApiRequestParams.class));
	}

	@Override
	public boolean deleteTestApi(String id) {
		return testApiService.removeById(id);
	}

	@Override
	public boolean deleteAllTestApi(String apiId) {
		return testApiService.remove(WrapperUtils.getQueryWrapperApiId(apiId, OpenapiTestApi.class));
	}

	@Override
	public IPage<OpenapiTestApi> pageTestApi(Page<OpenapiTestApi> p, String apiId) {
		return testApiService.page(p, WrapperUtils.getQueryWrapperApiId(apiId, OpenapiTestApi.class));
	}
}
