package com.bizvane.openapi.business.modules.test.service.impl;

import com.bizvane.openapi.business.consts.CodeMessageConsts.Business;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApiHistory;
import com.bizvane.openapi.business.modules.test.mapper.OpenapiTestApiHistoryMapper;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiHistoryService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.utils.Assert;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.Date;

import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * <p>
 * 接口测试记录 服务实现类
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-26
 */
@Service
public class OpenapiTestApiHistoryServiceImpl extends ServiceImpl<OpenapiTestApiHistoryMapper, OpenapiTestApiHistory> implements OpenapiTestApiHistoryService {

	@Override
	public boolean save(OpenapiTestApiHistory entity) {
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		Assert.missing(entity.getTestApiId(), "TestApiId");
		Assert.missing(entity.getTestResult(), "TestResult");
		Assert.missing(entity.getTestCost(), "TestCost");
		if(!StringUtils.hasText(entity.getBusinessId())) {
			entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
		}
		Assert.hasText(entity.getBusinessId(), Business.BUSINESS_ID_EMPTY);
		
		Date now = new Date();
		entity
		.setCreateTime(now)
		.setId(null);
		return super.save(entity);
	}

	
}
