package com.bizvane.openapi.business.modules.test.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 接口测试请求管理
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="OpenapiTestApiRequest对象", description="接口测试请求管理")
public class OpenapiTestApi implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键, 自动生成UUID")
    @TableId(value = "id", type = IdType.UUID)
    private String id;

    @ApiModelProperty(value = "测试接口名称")
    private String name;

    @ApiModelProperty(value = "是否为主测试")
    private Boolean isPrimary;

    @ApiModelProperty(value = "接口信息ID")
    private String apiId;

    @ApiModelProperty(value = "版本(预留)")
    private Float version;

    @ApiModelProperty(value = "商户号/商户ID")
    private String businessId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;


}
