package com.bizvane.openapi.business.modules.service.vo;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author wang.zeyan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "ServiceApiInfoVO", description = "服务/接口映射关系")
public class ServiceApiInfoVO {

    @ApiModelProperty(value = "接口id")
    private String apiId;

    @ApiModelProperty(value = "服务id")
    private String serviceId;

    @ApiModelProperty(value = "服务名称")
    private String serviceName;

    @ApiModelProperty(value = "服务别名")
    private String serviceAlias;

    @ApiModelProperty(value = "接口名称")
    private String apiName;

    @ApiModelProperty(value = "接口别名")
    private String alias;

    @ApiModelProperty(value = "接口地址")
    private String url;

    @ApiModelProperty(value = "接口请求方法")
    private String method;
}
