package com.bizvane.openapi.business.modules.developeraccount.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.consts.CodeMessageConsts.Business;
import com.bizvane.openapi.business.consts.StringConsts;
import com.bizvane.openapi.business.consts.StringConsts.DeveloperAccount;
import com.bizvane.openapi.business.modules.developeraccount.entity.OpenapiDeveloperAccount;
import com.bizvane.openapi.business.modules.developeraccount.enums.DeveloperAccountTypeEnum;
import com.bizvane.openapi.business.modules.developeraccount.service.OpenapiDeveloperAccountManager;
import com.bizvane.openapi.business.modules.developeraccount.service.OpenapiDeveloperAccountService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.utils.Assert;
import com.bizvane.openapi.common.utils.GeneratorUtils;

/**
 * 
 * @author wang.zeyan
 *  2019年5月9日
 */
@Service
public class OpenapiDeveloperAccountManagerImpl implements OpenapiDeveloperAccountManager {

	@Autowired
	OpenapiDeveloperAccountService developerAccountService;
	
	
	@Transactional(rollbackFor = RuntimeException.class)
	@Override
	public OpenapiDeveloperAccount applyToDeveloper() {
		
		return applyToDeveloperAccount(DeveloperAccountTypeEnum.developer);
	}
	
	@Transactional(rollbackFor = RuntimeException.class)
	@Override
	public OpenapiDeveloperAccount applyToProvider() {
		
		return applyToDeveloperAccount(DeveloperAccountTypeEnum.provider);
	}

	private OpenapiDeveloperAccount applyToDeveloperAccount(DeveloperAccountTypeEnum type) {

		if(type == DeveloperAccountTypeEnum.provider) {
			// 服务者账号是否存在
			OpenapiDeveloperAccount one = developerAccountService.getOne(new QueryWrapper<OpenapiDeveloperAccount>().eq(DeveloperAccount.TYPE, type));
			Assert.isTrue(one == null, type ==  DeveloperAccountTypeEnum.provider? Business.PROVIDER_EXIST : Business.DEVELOPER_EXIST);
		}

		String appkey = GeneratorUtils.uuid();
		String appSecret = GeneratorUtils.md5DigestAsHex(appkey);
		OpenapiDeveloperAccount entity = new OpenapiDeveloperAccount();
		entity.setAppKey(appkey);
		entity.setAppSecret(appSecret);
		entity.setType(type);
		entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
		developerAccountService.save(entity);
		return entity;
	}

	@Override
	public OpenapiDeveloperAccount get(String id) {
		return developerAccountService.getById(id);
	}

	@Override
	public IPage<OpenapiDeveloperAccount> pageDeveloperAccount(Page<OpenapiDeveloperAccount> p,
			QueryWrapper<OpenapiDeveloperAccount> wrapper) {
		return developerAccountService.page(p, wrapper);
	}

	@Override
	public List<OpenapiDeveloperAccount> listDeveloperAccount() {
		return developerAccountService.list();
	}

	@Override
	public OpenapiDeveloperAccount getDeveloperAccount(String appKey) {
		OpenapiDeveloperAccount developerAccount = developerAccountService.getOne(new QueryWrapper<OpenapiDeveloperAccount>()
				.eq(StringConsts.DeveloperAccount.APP_KEY, appKey));
		return developerAccount;
	}

	@Override
	public OpenapiDeveloperAccount getProviderDeveloperAccount(String businessId) {
		OpenapiDeveloperAccount one = developerAccountService.getOne(new QueryWrapper<OpenapiDeveloperAccount>().eq(StringConsts.DeveloperAccount.TYPE, StringConsts.DeveloperAccount.PROVIDER_ACCOUNT));
		return one;
	}
}
