package com.bizvane.openapi.business.modules.developeraccount.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bizvane.openapi.business.modules.developeraccount.enums.DeveloperAccountTypeEnum;

import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 开发者/服务者账号
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="OpenapiDeveloperAccount对象", description="开发者/服务者账号")
public class OpenapiDeveloperAccount implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.UUID)
    private String id;

    @ApiModelProperty(value = "appkey")
    private String appKey;

    @ApiModelProperty(value = "appsecret")
    private String appSecret;

    @ApiModelProperty(value = "开发者账号[developer],服务者账号[provider]")
    private DeveloperAccountTypeEnum type;

    @ApiModelProperty(value = "webhook地址")
    private String webhookUrl;

    @ApiModelProperty(value = "手机号")
    private String mobileNumber;

    @ApiModelProperty(value = "账号状态(0新建[默认],1通过,2冻结,3注销)")
    private Integer status;

    @ApiModelProperty(value = "商户号/商户ID")
    private String businessId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;


}
