package com.bizvane.openapi.business.modules.api.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiRequestParams;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiResponseParams;
import com.bizvane.openapi.business.modules.api.vo.ApiInfoVO;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author wang.zeyan
 * 2019年4月24日
 */
public interface OpenapiApiManager {


    /**
     * 接口列表
     *
     * @param page
     * @param wrapper
     * @return
     */
    IPage<OpenapiApiInfo> pageApiInfo(Page<OpenapiApiInfo> page, QueryWrapper<OpenapiApiInfo> wrapper);

    /**
     * 添加接口信息
     *
     * @param entity
     * @return
     */
    boolean addApiInfo(OpenapiApiInfo entity);

    /**
     * 添加返回参数信息
     *
     * @param entity
     * @param apiId
     * @return
     */
    boolean addApiResponseParams(OpenapiApiResponseParams entity, String apiId);

    /**
     * 添加请求参数信息
     *
     * @param entity
     * @param apiId
     * @return
     */
    boolean addApiRequestParams(OpenapiApiRequestParams entity, String apiId);

    /**
     * 修改接口信息
     *
     * @param entity
     * @param id
     * @return
     */
    boolean updateApiInfo(OpenapiApiInfo entity, String id);

    /**
     * 修改接口请求参数信息
     *
     * @param entity
     * @param id
     * @return
     */
    boolean updateApiRequestParams(OpenapiApiRequestParams entity, String id);


    /**
     * 修改接口返回参数信息
     *
     * @param entity
     * @param id
     * @return
     */
    boolean updateApiResponseParams(OpenapiApiResponseParams entity, String id);

    /**
     * 获取接口信息
     *
     * @param id
     * @return
     */
    OpenapiApiInfo getApiInfo(String id);

    /**
     * 获取接口请求参数信息列表
     *
     * @param apiId
     * @return
     */
    List<OpenapiApiRequestParams> getApiRequestParams(String apiId);

    /**
     * 获取接口请求参数信息Map
     *
     * @param apiId
     * @return
     */
    Map<String, OpenapiApiRequestParams> getApiRequestParamsMap(String apiId);

    /**
     * 获取返回参数信息列表
     *
     * @param apiId
     * @return
     */
    List<OpenapiApiResponseParams> getApiResponseParams(String apiId);

    /**
     * 获取接口信息详情(包含请求参数信息 和 返回参数信息)
     *
     * @param apiId
     * @return
     */
    ApiInfoVO getApiInfoDetail(String apiId);

    /**
     * 删除接口信息
     *
     * @param id
     * @return
     */
    boolean deleteApiInfo(String id);

    /**
     * 删除接口请求参数信息
     *
     * @param id
     * @return
     */
    boolean deleteApiRequestParams(String id);

    /**
     * 删除接口返回参数信息
     *
     * @param id
     * @return
     */
    boolean deleteApiResponseParams(String id);

    /**
     * 根据ids查询apiInfo
     *
     * @param apiIds
     * @return
     */
    List<OpenapiApiInfo> listApiInfo(Collection<String> apiIds);

    /**
     * 查询所有接口
     *
     * @return
     */
    List<OpenapiApiInfo> listAll();
}
