package com.bizvane.openapi.business.modules.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 接口示例
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-07-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "OpenapiApiExample对象", description = "接口示例")
public class OpenapiApiExample implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "接口ID")
    @TableId(value = "api_id", type = IdType.UUID)
    private String apiId;

    @ApiModelProperty(value = "请求示例")
    private String requestExample;

    @ApiModelProperty(value = "返回示例")
    private String responseExample;

    @ApiModelProperty(value = "商户ID", hidden = true)
    private String businessId;

    @ApiModelProperty(value = "创建时间", hidden = true)
    private Date createTime;

    @ApiModelProperty(value = "修改时间", hidden = true)
    private Date modifyTime;


}
