package com.bizvane.openapifacade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lijiachun
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponByCard361ListResVO {

    /**
     * 券定义id
     */
   private Long couponDefinitionId;

    /**
     * 券code
     */
   private String couponCode;

    /**
     * 券名称
     */
   private String 	couponName;

    /**
     * 券类型（1现金，2折扣，3礼品）
     */
   private String preferentialType;

    /**
     * 会员code
     */
   private String memberCode;

    /**
     * 券有效开日期
     */
   private String validDateStart;

    /**
     * 券有效结束日期
     */
   private String validDateEnd;

    /**
     * 券面额
     */
   private BigDecimal money;

    /**
     * 券折扣
     */
   private BigDecimal discount;

    /**
     * 券描述
     */
   private String info;

    /**
     * 券使用类型 :1.线上 2.线下
     */
   private Integer useType;

    /**
     * 使用门店code
     */
   private String useStoreCode;

    /**
     * 使用订单号
     */
   private String useBusinessOrder;

    /**
     * 使用订单号金额
     */
   private BigDecimal useBusinessOrderAmount;

    /**
     * 使用时间
     */
   private String useTime;

    /**
     * 券状态:20.未使用,25:已过,30:已核销
     */
   private Integer couponStatus;

    /**
     * 是否使用:0.未使用,1:已使用
     */
   private Integer isUse;

    /**
     * 转增状态:0.未转增,1:已转增）
     */
   private Integer give;

    /**
     * 是否锁定
     */
   private Integer isLock;

    /**
     * 线下卷类型号
     * */
    private String erpCouponDefinitionCode;

    /**
     * 渠道限制（1仅线下，2全渠道，3仅线上，4员工券，5天猫券）
     * */
    private Byte useChannel;

    @ApiModelProperty(value = "361定制：是否支付宝券1-是，0-否", name = "isAlipayCoupon")
    private Boolean isAlipayCoupon;

    @ApiModelProperty(value = "创建时间", name = "createDate")
    private Date createDate;

    @ApiModelProperty(value = "修改时间", name = "modifiedDate")
    private Date modifiedDate;

    @ApiModelProperty(value = "券是否隐藏 1是0否已隐藏仅代表不在会员中心显示，券状态未做修改", name = "isHide")
    private Integer isHide;


}
