package com.bizvane.openapifacade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @author lijiachun
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class DefCouponQueryInfo361ListResVO {

    /**
     * 券定义id
     */
   private Long couponDefinitionId;

    /**
     * 券定义code
     */
   private String couponDefCode;

    /**
     * 券定义名称
     */
   private String couponDefName;

    /**
     * 券类型（1现金，2折扣，3兑换）
     */
   private Integer preferentialType;

    /**
     * 券面额
     */
   private BigDecimal money;

    /**
     * 券折扣
     */
   private BigDecimal discount;

    /**
     * 券定义描述
     */
   private String info;

    /**
     * 有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天
     */
    private Integer validType;

    /**
     * 券有效开日期
     */
    private String validDateStart;

    /**
     * 券有效结束日期
     */
    private String validDateEnd;

    /**
     * 领取X天后生效
     */
   private Integer delayDay;

    /**
     * 领取X天后有效期X天
     */
   private Integer delayValidDay;

    /**
     * 单人最大领取数量
     */
   private Integer perMaxNum;

    /**
     * 最低消费金额(满减金额)
     */
   private BigDecimal minConsume;

    /**
     * 最高优惠金额
     */
   private BigDecimal maxPreferential;

    /**
     * 商品数量最低限制
     */
   private Integer minCommodityNum;

    /**
     * 商品数量最高限制
     */
   private Integer maxCommodityNum;

    /**
     * 整单最低折扣限制
     */
   private BigDecimal minDiscount;

    /**
     * 适用商品类型：1-全部适用，2-部分适用
     */
   private Integer applianceCommodityType;

    /**
     * 商品白名单
     */
    private String commodityWhitelist;

    /**
     * 商品黑名单
     */
    private String commodityBlacklist;

    /**
     * 线下商品code
     */
    private String offlinePrdCode;

    /**
     * 商品复合白名单
     */
    private String commodityCompoundWhitelist;

    /**
     * 店铺白名单
     */
    private String storeWhitelist;

    /**
     * 店铺黑名单
     */
    private String storeBlacklist;

    @ApiModelProperty(value = "361定制：是否支付宝券1-是，0-否", name = "isAlipayCoupon")
    private Boolean isAlipayCoupon;

}
