package com.bizvane.mktcenterservice.interfaces.mktp;

import com.bizvane.mktcenterservice.models.po.MktpActivityStepPO;
import com.bizvane.mktcenterservice.models.vo.mktp.MktpActivityStepVO;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;

/**
 * @author yuantq
 * @date 2023/6/21
 */
public interface MktpActivityStepService {

    /**
     * 新增活动阶梯配置
     * @param mktpActivityStepVOList
     * @param sysAccountPo
     * @param mktpActivityId
     */
    void addAllMktpActivityStep(List<MktpActivityStepVO> mktpActivityStepVOList, SysAccountPO sysAccountPo, Long mktpActivityId);

    /**
     * 根据活动主体ID获取活动阶梯信息
     * @param mktpActivityId
     * @return
     */
    List<MktpActivityStepVO> getStepVOListActivityId(Long mktpActivityId);

    /**
     * 根据活动ID删除其下阶梯
     * @param mktpActivityId
     */
    void deleteAllStep(Long sysCompanyId, Long sysBrandId, Long mktpActivityId);

    /**
     * 根据阶梯ID获取阶梯信息
     * @param mktpActivityStepId
     * @return
     */
    MktpActivityStepPO getActivityStepPOById(Long mktpActivityStepId);

    /**
     * 修改阶梯已使用奖品数量
     * @param mktpActivityStepPO
     * @return
     */
    int updatePriceSunUse(MktpActivityStepPO mktpActivityStepPO);
}
