package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.bo.ActivityPrizePickUpBO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizePickUpVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;

/**
 * 营销实物奖品自提
 * @author yuantq
 * @date 2022/5/26
 */
public interface ActivityPrizePickUpService {

    /**
     * 获取中奖提货信息
     * @param activityPrizePickUpVO
     * @return
     */
    ResponseData<ActivityPrizePickUpBO> getActivityPrizeRecordDetail(ActivityPrizePickUpVO activityPrizePickUpVO);

    /**
     * 确认提货
     * @param activityPrizePickUpVO
     * @return
     */
    ResponseData confirmPickUp(ActivityPrizePickUpVO activityPrizePickUpVO);

    /**
     * 查询营销-新转盘提货列表
     * @param activityPrizePickUpVO
     * @return
     */
    ResponseData<PageInfo<ActivityPrizePickUpBO>> selectPickUpList(ActivityPrizePickUpVO activityPrizePickUpVO);

}
