package com.bizvane.mktcenterservice.models.po;

import com.bizvane.members.facade.models.ExtendPropertyModel;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 活动表-线下活动报名
 */
@Data
public class ActivityRegistrationPO {
    /**
     * pkid
     */
    private Long mktActivityRegistrationId;

    /**
     * 企业id
     */
    private Long sysCompanyId;

    /**
     * 关联活动id
     */
    private Long mktActivityId;

    /**
     * 活动限制的参与会员等级编号
     */
    private String mbrLevelCode;

    /**
     * 活动限制的参与会员等级名称
     */
    private String mbrLevelName;

    /**
     * 针对的会员类型：0,所有类型，1微信会员
     */
    private Integer memberType;

    /**
     * 非会员是否可以报名 true为可以
     */
    @ApiModelProperty("非会员是否可以报名")
    private Boolean nonMemberSignUp;

    /**
     * 报名所需费用 0为无需
     */
    @ApiModelProperty("报名需要积分 0为不需要")
    private Integer needPoint;

    /**
     * 报名报名人数限制 空/0为不限制
     */
    @ApiModelProperty("报名人数上限 0为不限")
    private Integer signUpLimit;

    /**
     * 报名所需资料 json
     */
    @ApiModelProperty("报名所需资料")
    private List<ExtendPropertyModel> customProperty;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人id
     */
    private Long createUserId;

    /**
     * 创建人
     */
    private String createUserName;

    /**
     * 创建日期
     */
    private Date createDate;

    /**
     * 修改人id
     */
    private Long modifiedUserId;

    /**
     * 修改人
     */
    private String modifiedUserName;

    /**
     * 修改时间
     */
    private Date modifiedDate;

    /**
     * 数据有效性：1=有效；0=无效
     */
    private Boolean valid;

    private String additionalInformationJson;

    public String getAdditionalInformationJson() {
        if (StringUtils.isNotBlank(additionalInformationJson)) {
            return additionalInformationJson;
        } else {
            return additionalInformationJson = JacksonUtil.bean2Json(customProperty);
        }
    }

    public List<ExtendPropertyModel> getCustomProperty() {
        if (CollectionUtils.isNotEmpty(customProperty)) {
            return customProperty;
        } else if (StringUtils.isNotBlank(additionalInformationJson)) {
            return customProperty = JacksonUtil.json2List(additionalInformationJson, ExtendPropertyModel.class);
        } else {
            return Collections.emptyList();
        }
    }
}