package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @description:
 * @author: Liu Xinpeng
 * @create: 2020-08-17 15:32
 **/

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class MktMessageNewPo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 消息内容
     */
    private String msgContent;

    /**
     * 只读. 消息业务类型：1活动，2任务. biz_type
     */
    private Integer bizType;

    /**
     * 消息类型，1模板消息，2短信,3图文消息
     */
    private String msgType;
    /**
     * 只读. 业务单号id. biz_id
     */
    private Long bizId;

    /**
     * 只读. 立即发送：1是，0否（完善资料任务：1=启用 0=禁止）. send_immediately
     */
    private Boolean sendImmediately;

    /**
     * 活动编号
     */
    private String ActivityId;

    /**
     * 只读. 开始发送时间. send_time
     */
    private Date sendTime;

    /**
     * 只读. pkid. mkt_msg_id
     */
    private Long mktMsgId;

    /**
     * 只读. . sys_company_id
     */
    private Long sysCompanyId;

    /**
     * 链接地址(微信模板链接)
     */
    private String link;

    /**
     * 消息的具体详情(文本框)
     */
    private String msgTail;

    /**
     * 头内容或首标语
     */
    private String first;

    /**
     * 国内模板编号
     */
    private String templateCodeCn;

    /**
     * 消息模板id
     */
    private String templateMsgId;

    /**
     * 消息发送是否排除微信会员，1是，0否
     */
    private Boolean exceptWechat;

    /**
     * 创建人id
     */
    private Long createUserId;

    /**
     * 创建人
     */
    private String createUserName;

    /**
     * 修改时间
     */
    private Date modifiedDate;

    /**
     * 创建日期
     */
    private Date createDate;


    /**
     * 数据有效性：1=有效；0=无效
     */
    private Boolean valid;


}