package com.bizvane.mktcenterservice.models.po;

import lombok.*;

import java.io.Serializable;
import java.util.Date;

/**
 * 自动营销任务执行子表
 * @author lipeng
 */
@Data
@ToString
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MktAutoTaskExecuteRecordPO implements Serializable {

    @io.swagger.annotations.ApiModelProperty(value = "pkid", name = "执行记录主键id", required = false, example = "")
    private Long autoTaskRecordId;
    @io.swagger.annotations.ApiModelProperty(value = "sysCompanyId", name = "所属企业id", required = false, example = "")
    private Long sysCompanyId;
    @io.swagger.annotations.ApiModelProperty(value = "sysBrandId", name = "所属品牌id", required = false, example = "")
    private Long sysBrandId;
    @io.swagger.annotations.ApiModelProperty(value = "autoTaskDefId", name = "关联自动营销id", required = false, example = "")
    private Long autoTaskDefId;
    @io.swagger.annotations.ApiModelProperty(value = "autoTaskCountId", name = "关联主任务id", required = false, example = "")
    private Long autoTaskCountId;
    @io.swagger.annotations.ApiModelProperty(value = "wavesOrdinal", name = "波次序号", required = false, example = "")
    private String wavesOrdinal;
    @io.swagger.annotations.ApiModelProperty(value = "aimsMemberNumber", name = "目标会员人数", required = false, example = "")
    private Integer aimsMemberNumber;
    @io.swagger.annotations.ApiModelProperty(value = "arriveNumber", name = "到达张数", required = false, example = "")
    private Integer arriveNumber;
    @io.swagger.annotations.ApiModelProperty(value = "messageReachNumber", name = "消息触达人数", required = false, example = "")
    private Integer messageReachNumber;
    @io.swagger.annotations.ApiModelProperty(value = "executionDate", name = "数据有效性 1=有效 0=无效", required = false, example = "")
    private Date executionDate;
    @io.swagger.annotations.ApiModelProperty(value = "valid", name = "数据有效性 1=有效 0=无效", required = false, example = "")
    private Integer valid;
    @io.swagger.annotations.ApiModelProperty(value = "remark", name = "备注", required = false, example = "")
    private String remark;
    @io.swagger.annotations.ApiModelProperty(value = "createUserId", name = "创建人id", required = false, example = "")
    private Integer createUserId;
    @io.swagger.annotations.ApiModelProperty(value = "createUserName", name = "创建人名称", required = false, example = "")
    private String createUserName;
    @io.swagger.annotations.ApiModelProperty(value = "createDate", name = "创建日期", required = false, example = "")
    private Date createDate;
    @io.swagger.annotations.ApiModelProperty(value = "modifiedUserId", name = "修改人id", required = false, example = "")
    private Long modifiedUserId;
    @io.swagger.annotations.ApiModelProperty(value = "modifiedUserName", name = "修改人名称", required = false, example = "")
    private String modifiedUserName;
    @io.swagger.annotations.ApiModelProperty(value = "modifiedDate", name = "修改日期", required = false, example = "")
    private Date modifiedDate;
    @io.swagger.annotations.ApiModelProperty(value = "version", name = "版本号", required = false, example = "")
    private Integer version;

}