package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @description: 活动对应会员信息
 * @author: Liu Xinpeng
 * @create: 2020-09-03 17:32
 **/
@Data
@Builder
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
public class ActivityMemberVo implements Serializable {

    /**
     * 活动编号
     */
    private String taskCode;

    /**
     * 活动名称
     */
    private String taskName;



    /**
     * 会员编号
     */
    private String activityType;

    /**
     * 子商户号
     */
    private String subMerchantId;
    /**
     * 会员卡等级
     */
    private String levelId;

    /**
     * 性别
     */
    private String gender;

    /**
     * 生日
     */
    private String birthday;

    /**
     * 昵称
     */
    private String name;

    /**
     * 区域
     */
    private String area;

    /**
     * 开卡门店
     */
    private String openCardStore;

    /**
     * 券核销门店
     */
    private String couponUsedStore;

    /**
     * 首单时间
     */
    private String firstOrderTime;


}