package com.bizvane.mktcenterservice.rpc.newmkt;

import com.bizvane.mktcenterservice.models.newmkt.MktReceiveCouponActivityVO;
import com.bizvane.mktcenterservice.models.newmkt.MktReceiveCouponExecuteVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author ljc
 * @date on 2020/8/27 11:17
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/activityReceiveCouponRpc")
public interface ActivityReceiveCouponRpcService {

    /**
     * 查询扫码领券活动券列表
     * @param brandId
     * @param companyId
     * @param taskCode
     * @param memberCode
     * @return
     */
    @RequestMapping("getReceiveCouponListByQrCode")
    ResponseData<MktReceiveCouponActivityVO> getReceiveCouponListByQrCode(@RequestParam("brandId") Long brandId, @RequestParam("companyId") Long companyId,
                                                                  @RequestParam("taskCode") String taskCode, @RequestParam("memberCode") String memberCode);

    /**
     * 查询领券活动券列表
     * @param brandId
     * @param companyId
     * @param memberCode
     * @return
     */
    @RequestMapping("getReceiveCouponList")
    ResponseData<List<MktReceiveCouponActivityVO>> getReceiveCouponList(@RequestParam("brandId") Long brandId, @RequestParam("companyId") Long companyId, @RequestParam("memberCode") String memberCode);


    /**
     * 领券
     * @param vo
     * @return
     */
    @RequestMapping("executeReceiveCoupon")
    ResponseData<Integer> executeReceiveCoupon(@RequestBody MktReceiveCouponExecuteVO vo);
}
