package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.bo.TaskAwardBO;
import com.bizvane.mktcenterservice.models.bo.TaskQuestionnaireRewardBO;
import com.bizvane.mktcenterservice.models.vo.TaskVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author: lijc
 * @Time: 2019年11月22日14:26:56
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/taskQuestionnaireRpc")
public interface TaskQuestionnaireServiceRpc {

    @PostMapping("getTempCodeByTaskId")
    ResponseData<String> getTempCodeByTaskId(@RequestBody TaskVO taskVO);

    @PostMapping("doTaskQuestionnaire")
    ResponseData doTaskQuestionnaire(@RequestBody TaskAwardBO bo);

    @PostMapping("getTaskRewardDetail")
    ResponseData<TaskQuestionnaireRewardBO> getTaskRewardDetail(@RequestParam("mktTaskId") Long mktTaskId);

    /**
     * 判断调查问卷模板是否被未结束的调查问卷任务引用
     * @param sysBrandId
     * @param templateCode
     * @return
     */
    @PostMapping("taskHaveReferenceTemplate")
    ResponseData<Boolean> taskHaveReferenceTemplate(@RequestParam("sysBrandId") Long sysBrandId,
                                                    @RequestParam("templateCode") String templateCode);
}

