package com.bizvane.mktcenterservice.models.vo;

import com.bizvane.core.facade.models.vo.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Data
@ApiModel("积分商城活动券分析查询")
public class IntegralActivityCouponAnalyseResponseVo {


    @ApiModelProperty(value ="优惠券名称", hidden = true)
    private String couponName;

    @ApiModelProperty(value = "积分价")
    private BigDecimal integralPrice;

    @ApiModelProperty(value = "现金价")
    private String cashPrice;

    @ApiModelProperty(name = "users",notes = "兑换人数")
    private Long users;

    @ApiModelProperty(name = "changeNum",notes = "兑换个数--这个是积分商城记录的券个数")
    private Long changeNum;

    @ApiModelProperty(name = "usedNum",notes = "核销张数")
    private Long usedNum;

    @ApiModelProperty(name = "unUsedNum",notes = "待核销张数")
    private Long unUsedNum;

    @ApiModelProperty(name = "cash",notes = "券收益")
    private BigDecimal cash=BigDecimal.ZERO;

    @ApiModelProperty(name = "userRate",notes = "核销率")
    private BigDecimal userRate=BigDecimal.ZERO;

    @ApiModelProperty(name = "exchangeCode",notes = "券编号")
    private String exchangeCode;

}
