package com.bizvane.mktcenterservice.rpc;

import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.mktcenterservice.models.bo.ActivityBO;
import com.bizvane.mktcenterservice.models.bo.ActivityGameBO;
import com.bizvane.mktcenterservice.models.bo.ActivityGivenGameTimesBO;
import com.bizvane.mktcenterservice.models.bo.ActivityOrderBO;
import com.bizvane.mktcenterservice.models.po.MktActivityFirstOrderPO;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityRecordPO;
import com.bizvane.mktcenterservice.models.vo.*;
import com.bizvane.mktcenterservice.models.vo.tree3.GetGameActivityListReqVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by agan on 2018/7/27.
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/activityRpc")
public interface ActivityServiceRpc {
 /**
  * 审核
  *
  * @param
  * @return
  */
 @RequestMapping("checkActivityById")
 ResponseData<Integer> checkActivityByIdRpc(@RequestBody SysCheckPo po);
 
 /**
   *会员首单
  *必填字段sysCompanyId，sysBrandId，memberCode，orderDate
  * @param
  * @return
  */
 @RequestMapping("saveFristOrder")
 public ResponseData<String> saveFristOrder(@RequestBody MktActivityFirstOrderPO po);

 /**
  * 禁用/启用活动
  *
  * @param vo
  * @return
  */
 @RequestMapping("updateActivityById")
 public ResponseData<Integer> updateActivityById(@RequestBody ActivityVO vo);

 /**
  * 查询开卡活动详情
  *
  * @param activityCode
  * @return
  */
 @RequestMapping("selectActivityRegisterById")
 public ResponseData<ActivityBO> selectActivityRegisterById(@RequestParam("activityCode") String activityCode);

 /**
  * 查询活动详情
  *
  * @param activityCode
  * @return
  */
 @RequestMapping("selectActivityOrderById")
 public ResponseData<ActivityBO> selectActivityOrderById(@RequestParam("activityCode") String activityCode);

 /**
  * 查询活动详情
  *
  * @param activityCode
  * @return
  */
 @RequestMapping("selectActivityUpgradesById")
 ResponseData<ActivityBO> selectActivityUpgradesById(@RequestParam("activityCode") String activityCode);

 /**
  *宝宝生日
  */
 @RequestMapping("selectActivityBabyBirthdayById")
 public ResponseData<ActivityBO> selectActivityBabyBirthdayById(@RequestParam("activityCode") String activityCode);

 /**
  *首单
  */
 @RequestMapping("selectActivityFirstOrderById")
 public ResponseData<ActivityBO> selectActivityFirstOrderById(@RequestParam("activityCode") String activityCode);
 /**
  * 小程序端活动列表
  *
  * @param vo
  * @return
  */
 @RequestMapping("getActivityList")
 ResponseData<List<ActivityVO>> getActivityList(@RequestBody ActivityVO vo);

 /**
  * 获取会员连续签到，累计签到天数
  * @param requestVO
  * @return
  */
 @RequestMapping("getSignInDays")
 ResponseData<MktActivitySignInDayVO> getSignInDays(@RequestBody MktActivitySignInRequestVO requestVO);

 /**
  * 获取活动描述和简介
  * @param requestVO
  * @return
  */
 @RequestMapping("getActivityInfo")
 ResponseData<ActivityInfoResponseVO> getActivityInfo(@RequestBody MktActivitySignInRequestVO requestVO);

 /**
  * 签到列表
  * @param vo
  * @return
  */
 @RequestMapping("getActivityRecordPOList")
 public ResponseData getActivityRecordPOList(@RequestBody MktActivityRecordVO vo);
 /**
  * 查询会员该签到活动是否可参与
  * @param
  * @return
  */
 @RequestMapping("getIsSignAble")
 public ResponseData<Boolean> getIsSignAble(@RequestBody MktActivitySignMemberVO vo);
 /**
  * 执行活动
  * @param
  * @return
  */
 @RequestMapping("executeActivitySignin")
 ResponseData<MktAppletActivitySignInPrizeDetailVO> executeActivitySignin(@RequestBody MktActivitySignMemberVO vo);

 /**
  * 小程序签到活动奖励规则
  * @param vo
  * @return
  */
 @RequestMapping("getActivitySignInPrizeInfo")
 ResponseData<MktAppletActivitySignInPrizeInfoVO> getActivitySignInPrizeInfo(@RequestBody MktActivityRecordVO vo);


 /**
  * 执行评价奖励活动
  * @param vo
  * @return
  */
 @RequestMapping("executeEvaluationActivity")
 public ResponseData<Integer> executeActivityEvaluation(@RequestBody MemberInfoModel vo);

 /**
  * 执行开卡活动
  * @param vo
  * @return
  */
 @RequestMapping("executeActivity")
 ResponseData<Integer> executeActivity(@RequestBody MemberInfoModelVOActivity vo);

 /**
  * 升级活动
  * @param vo
  * @return
  */
 @RequestMapping("executeUpgrades")
 ResponseData<Integer> executeUpgrades(@RequestBody MemberInfoModel vo);

 @RequestMapping("judgeMember")
 public  ResponseData<Integer> judgeMember(@RequestBody JudgeMemberVO vo);

 @RequestMapping("getMinActivityEvaluationWordNum")
 public ResponseData<Integer> getMinActivityEvaluationWordNum(@RequestBody MemberInfoModel vo);
 
 /**
  * 查询活动详情，小程序端使用
  *
  * @param activityCode
  * @return
  */
 @RequestMapping("selectActivityOrderById2C")
 ResponseData<ActivityOrderBO> selectActivityOrderById2C(@RequestParam("activityCode") String activityCode);

 /**
  * 根据品牌ID，会员code,订单号查询订单相关活动赠送的最老的可执行游戏信息
  * @param sysBrandId
  * @param memberCode
  * @param orderNo
  * @return
  */
 @RequestMapping("selectOldGivenGameActivity")
 ResponseData<ActivityGameBO> selectOldGivenGameActivity(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("memberCode") String memberCode
         , @RequestParam("orderNo") String orderNo);

 /**
  * 获取赠送该会员此游戏的剩余有效次数以及已使用的总次数
  * @param sysBrandId
  * @param memberCode
  * @param activityCode
  * @return
  */
 @RequestMapping("selectGivenGameNum")
 ResponseData<ActivityGivenGameTimesBO> selectGivenGameNum(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("memberCode") String memberCode, @RequestParam("activityCode") String activityCode);

 /**
  * 根据营销ID获取营销对象
  * @param mktActivityId
  * @return
  */
 @RequestMapping("selectMktActivity")
 ResponseData<MktActivityPOWithBLOBs> selectMktActivity(@RequestParam("mktActivityId") Long mktActivityId);

 /**
  * 查询签到活动详情
  * @param activityCode
  * @return
  */
 @RequestMapping("/selectSignActivityByCode")
 ResponseData<ActivityBO> selectSignActivityByCode(@RequestParam("activityCode") String activityCode);

 /**
  * 小程序获取会员签到记录奖励
  * @param requestVO
  * @return
  */
 @RequestMapping("selectSignInRecordInfoPage")
 ResponseData<PageInfo<MktAppletActivitySignInRecordVO>> selectSignInRecordInfoPage(@RequestBody MktActivityRecordRequestVO requestVO);

 /**
  * 小程序获取会员签到记录奖励
  * @param reqVO
  * @return
  */
 @PostMapping("/getGameActivityList")
 ResponseData<List<ActivityVO>> getGameActivityList(@RequestBody GetGameActivityListReqVO reqVO);
}
