package com.bizvane.mktcenterservice.interfaces;

import com.alipay.api.domain.AlipaySocialBaseContentlibStandardcontentBatchqueryModel;
import com.alipay.api.response.AlipaySocialBaseContentlibStandardcontentBatchqueryResponse;
import com.bizvane.alipayfacade.models.po.AlipayMaterialCityPo;
import com.bizvane.alipayfacade.models.po.AlipayMaterialImagePo;
import com.bizvane.alipayfacade.models.vo.alipay.AlipayImageRequestVo;
import com.bizvane.alipayfacade.models.vo.alipay.AlipayMaterialImageModifyVo;
import com.bizvane.alipayfacade.models.vo.alipay.AlipayMaterialImageSearchVo;
import com.bizvane.alipayfacade.models.vo.alipay.AlipayRequestVo;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

public interface ActivityAlipayVoucherMaterialService {
    /**
     * 查询资源库数据
     * @param requestVo
     * @return
     */
    ResponseData<PageInfo<AlipayMaterialImagePo>> queryMaterialImageList(AlipayMaterialImageSearchVo alipayMaterialImageSearchVo, SysAccountPO stageUser);


    ResponseData<AlipaySocialBaseContentlibStandardcontentBatchqueryResponse> socialBaseContentBatchQuery(AlipayMaterialImageSearchVo requestVo,SysAccountPO sysAccountPO);


    ResponseData<PageInfo<AlipayMaterialCityPo>> queryMaterialCityList(AlipayMaterialImageSearchVo requestVo, SysAccountPO sysAccountPO);

    ResponseData modifyMaterialImage(@RequestBody @Valid AlipayMaterialImageModifyVo alipayMaterialImagePo,  SysAccountPO sysAccountPO);

}
