package com.bizvane.mktcenterservice.models.newmkt;

import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * @author Ljc
 */

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MktMemActivityRewardRuleVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 排序值，与规则匹配
     */
    private Integer id;

    /**
     * 倍数积分的倍数
     */
    private Double multiple;

    /**
     * 奖励的整数积分值
     */
    private Double score;

    /**
     * 积分类型:simple:整数 multiple:倍数
     */
    private String scoreType;

    /**
     * 券
     */
    private List<MktMemActivityCouponVO> coupon;

    /**
     * 礼包
     */
    private MktMemActivityGiftBagVO giftBag;
}
