package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.interfaces.MktActivityPointsLootService;
import com.bizvane.mktcenterservice.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 积分夺宝活动 feign
 */

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mktActivityPointsLootRpc")
public interface MktActivityPointsLootServiceRpc {



    /**
     * 会员参与积分夺宝活动抽奖
     * @param vo
     * @return
     */
    @RequestMapping(value = "/participationActivity",method = RequestMethod.POST)
    ResponseData<String> participationActivity(@RequestBody MktActivityPointsLootRequestVo vo);

    /**
     * 查看积分夺宝活动详情
     * @param vo
     * @return
     */
    @RequestMapping(value = "/selectActivityDetail",method = RequestMethod.POST)
    ResponseData<MktActivityPointsLootVo> selectActivityDetail(@RequestBody MktActivityPointsLootRequestVo vo);

    /**
     * 查看积分夺宝活动中奖名单
     * @param vo
     * @return
     */
    @RequestMapping(value = "/selectDrawPrizeRecord",method = RequestMethod.POST)
    ResponseData<PageInfo<MktActivityPrizeRecordVO>> selectDrawPrizeRecord(@RequestBody MktActivityPointsLootRequestVo vo);

    /**
     * 查看积分夺宝活动会员参与记录
     * @param vo
     * @return
     */
    @RequestMapping(value = "/selectParticipationActivityRecord",method = RequestMethod.POST)
    ResponseData<PageInfo<MktMbrPrizeRecordVo>> selectParticipationActivityRecord(@RequestBody MktActivityPointsLootRequestVo vo);


    /**
     * 查询符合会员参与的积分夺宝活动列表
     * @param vo
     * @return
     */
    @RequestMapping(value = "/selectFitMbrActivityList",method = RequestMethod.POST)
    ResponseData<PageInfo<MktActivityPointsLootVo>> selectFitMbrActivityList(@RequestBody MktActivityPointsLootRequestVo vo);

}
