package com.bizvane.mktcenterservice.models.vo;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Author: lijc
 * @Time: 2019/10/29
 */
@Data
public class MktListRequestVO {

   /**
    * 营销类型 0:全部 1：活动 2：任务 3：游戏
    */
   private Integer mktType;

   /**
    * 状态  0全部，1待执行，2执行中，3已结束
    */
   private Integer status;

   /**
    * 开始时间
    */
   private String startDate;

   /**
    * 结束时间
    */
   private String endDate;

   @NotNull
   private Long sysCompanyId;

   @NotNull
   private Long sysBrandId;

   private Integer pageNumber = 0;

   private Integer pageSize = 5;

}
