package com.bizvane.mktcenterservice.rpc;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.mktcenterservice.models.bo.ActivityRedPacketBO;
import com.bizvane.mktcenterservice.models.bo.MktActivityRedPacketRecordBO;
import com.bizvane.mktcenterservice.models.po.MktActivityRedPacketBatchPO;
import com.bizvane.mktcenterservice.models.po.MktActivityRedPacketRecordPO;
import com.bizvane.mktcenterservice.models.vg.*;
import com.bizvane.mktcenterservice.models.vo.ActivityRedPacketV2VO;
import com.bizvane.mktcenterservice.models.vo.ActivityRedPacketVO;
import com.bizvane.mktcenterservice.models.vo.RedPacketSocketVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.validation.Valid;
import java.util.List;

/**
 * @Author: lijunwei
 * @Time: 2019/1/16 15:41
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/activityRedPacketRpc")
public interface ActivityRedPacketServiceRpc {
    @RequestMapping("selectActivityRedPacketDetail")
    public ResponseData<ActivityRedPacketBO> selectActivityRedPacketDetail(@RequestBody ActivityRedPacketVO vo);
    @RequestMapping("doIfActivityRedPacket")
    public ResponseData<Integer> doIfActivityRedPacket(@RequestBody ActivityRedPacketVO vo);
    @RequestMapping("andActivityRedPacketCreateRecord")
    public void andActivityRedPacketCreateRecord(@RequestBody ActivityRedPacketVO vo);
    @RequestMapping("andActivityRedPacketZhuliRecord")
    public ResponseData<Integer> andActivityRedPacketZhuliRecord(@RequestBody ActivityRedPacketVO vo);
    @RequestMapping("andActivityRedPacketSendCouponRecord")
    public ResponseData<Integer> andActivityRedPacketSendCouponRecord(@RequestBody ActivityRedPacketVO vo);
    @RequestMapping("getRedPacketZhuLiRecord")
    public ResponseData<List<MktActivityRedPacketRecordPO>> getRedPacketZhuLiRecord(@RequestBody ActivityRedPacketVO vo);
    @RequestMapping("getRedPacketZhuLiRecordByAPP")
    public ResponseData<JSONObject> getRedPacketZhuLiRecordByAPP(@RequestBody ActivityRedPacketVO vo);
    @RequestMapping("getRedPacketCoponAppRecord")
    public ResponseData<List<MktActivityRedPacketRecordBO>> getRedPacketCoponAppRecord(@RequestBody ActivityRedPacketVO vo);

    @RequestMapping({"selectActivityRedPacketV2"})
    ResponseData<ActivityRedPacketV2VO> selectActivityRedPacketV2(@RequestBody ActivityRedPacketVO vo);

    @RequestMapping({"judgeMemberCondition"})
    ResponseData<VGActivityJudgeMemberConditionResponseVo> judgeMemberCondition(@RequestBody VGActivityJudgeMemberConditionRequestVo vo);

    @RequestMapping({"selectActivityRedPacketMemberDoingBatchDetail"})
    ResponseData<MktActivityRedPacketBatchPO> selectActivityRedPacketMemberDoingBatchDetail(@RequestBody @Valid VGActivityMemberRequestVo vo);

    @RequestMapping({"andActivityRedPacketCreateRecordV2"})
    ResponseData<MktActivityRedPacketBatchPO> andActivityRedPacketCreateRecordV2(@RequestBody ActivityRedPacketVO vo);

    @RequestMapping({"andActivityRedPacketZhuliRecordV2"})
    ResponseData<ActivityRedPacketInvitedRewardVo> andActivityRedPacketZhuliRecordV2(@RequestBody VGActivityRedPacketInvitedRequestVo vo);

    @RequestMapping({"getRedPacketZhuLiRecordByAPPV2"})
    ResponseData<RedPacketSocketVO> getRedPacketZhuLiRecordByAPPV2(@RequestBody VGActivityRedPacketInvitedRequestVo vo);

    @RequestMapping({"selectActivityRedPacketMemberDetail"})
    ResponseData<VGActivityRedPacketDetailVO> selectActivityRedPacketMemberDetail(@RequestBody VGActivityRedPacketInvitedRequestVo vo);

    @RequestMapping({"beforeCheckActivityRedPacketSendCouponRecordCount"})
    ResponseData<Boolean> beforeCheckActivityRedPacketSendCouponRecordCount(@RequestBody VGActivityRedPacketInvitedRequestVo vo);

    @RequestMapping({"andActivityRedPacketSendCouponRecordV2"})
    ResponseData<VGActivityRedPacketDetailVO> andActivityRedPacketSendCouponRecordV2(@RequestBody VGActivityRedPacketInvitedRequestVo vo);

    @RequestMapping({"getActivityRedPacketPriceRecord"})
    ResponseData<VGActivityRedPacketPriceRecordResponseVO> getActivityRedPacketPriceRecord(@RequestBody ActivityRedPacketVO vo);

    @RequestMapping({"selectActivityRedPacketBatch"})
    ResponseData<MktActivityRedPacketBatchPO> selectActivityRedPacketBatch(@RequestBody VGActivityRedPacketInvitedRequestVo vo);


}
