package com.bizvane.mktcenterservice.models.po;

import lombok.*;

import java.io.Serializable;
import java.util.Date;

/**
 * 自动营销，发放人群表
 * @author lipeng
 */
@Data
@ToString
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MktAutoTaskMemberPO implements Serializable {

    @io.swagger.annotations.ApiModelProperty(value = "pkid", name = "待发券人群主键id", required = false, example = "")
    private Long autoTaskMemberId;
    @io.swagger.annotations.ApiModelProperty(value = "sysCompanyId", name = "所属企业id", required = false, example = "")
    private Long sysCompanyId;
    @io.swagger.annotations.ApiModelProperty(value = "sysBrandId", name = "所属品牌id", required = false, example = "")
    private Long sysBrandId;
    @io.swagger.annotations.ApiModelProperty(value = "autoTaskDefId", name = "关联自动营销id", required = false, example = "")
    private Long autoTaskDefId;
    @io.swagger.annotations.ApiModelProperty(value = "autoTaskRecordId", name = "关联执行记录主键id", required = false, example = "")
    private Long autoTaskRecordId;
    @io.swagger.annotations.ApiModelProperty(value = "openId", name = "会员openId", required = false, example = "")
    private String openId;
    @io.swagger.annotations.ApiModelProperty(value = "memberCode", name = "会员code", required = false, example = "")
    private String memberCode;
    @io.swagger.annotations.ApiModelProperty(value = "memberPhone", name = "会员手机号", required = false, example = "")
    private String memberPhone;
    @io.swagger.annotations.ApiModelProperty(value = "memberCardNo", name = "会员卡号", required = false, example = "")
    private String memberCardNo;
    @io.swagger.annotations.ApiModelProperty(value = "memberName", name = "会员姓名", required = false, example = "")
    private String memberName;
    @io.swagger.annotations.ApiModelProperty(value = "sendTime", name = "发送时间", required = false, example = "")
    private Date sendTime;
    @io.swagger.annotations.ApiModelProperty(value = "sendStatus", name = "发送状态(1-未发送 2-发送成功 3-发送失败 4-无需发送)", required = false, example = "")
    private String sendStatus;
    @io.swagger.annotations.ApiModelProperty(value = "valid", name = "数据有效性 1=有效 0=无效", required = false, example = "")
    private Integer valid;
    @io.swagger.annotations.ApiModelProperty(value = "remark", name = "备注", required = false, example = "")
    private String remark;
    @io.swagger.annotations.ApiModelProperty(value = "createUserId", name = "创建人id", required = false, example = "")
    private Integer createUserId;
    @io.swagger.annotations.ApiModelProperty(value = "createUserName", name = "创建人名称", required = false, example = "")
    private String createUserName;
    @io.swagger.annotations.ApiModelProperty(value = "createDate", name = "创建日期", required = false, example = "")
    private Date createDate;
    @io.swagger.annotations.ApiModelProperty(value = "modifiedUserId", name = "修改人id", required = false, example = "")
    private Long modifiedUserId;
    @io.swagger.annotations.ApiModelProperty(value = "modifiedUserName", name = "修改人名称", required = false, example = "")
    private String modifiedUserName;
    @io.swagger.annotations.ApiModelProperty(value = "modifiedDate", name = "修改日期", required = false, example = "")
    private Date modifiedDate;
    @io.swagger.annotations.ApiModelProperty(value = "version", name = "版本号", required = false, example = "")
    private Integer version;
    @io.swagger.annotations.ApiModelProperty(value = "couponDefinitionId", name = "券定义ids", required = false, example = "")
    private String couponDefinitionId;

}