package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @description: 活动分析列表requestVo
 * @author: Liu Xinpeng
 * @create: 2020-08-07 17:12
 **/
@Data
@Builder
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
public class ActivityAnalyzePageRequestVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 页数
     */
    private Integer pageNumber;

    /**
     * 每页的数量
     */
    private Integer pageSize;



    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动类型
     */
    private String activityType;



    /**
     * 开始时间  yyyy-MM-dd HH:mm:ss
     */
    private String startTime;

    /**
     * 结束时间  yyyy-MM-dd HH:mm:ss
     */
    private String endTime;


}