package com.bizvane.mktcenterservice.interfaces.newmkt;

import com.bizvane.mktcenterservice.models.newmkt.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;

/**
 * @program: mktcenter-parent
 * @description: 活动导出
 * @author: Liu Xinpeng
 * @create: 2020-08-25 11:08
 **/
@Service
public interface ActivityExportService {


    /**
     * 活动列表数据导出
     * @param requestVo
     * @param sysAccountPo
     * @return
     */
    ResponseData<String> activityAnalyzeListExport(ActivityListExportVo requestVo, SysAccountPO sysAccountPo);

    /**
     * 活动日/月/年业绩分析数据导出
     * @param activityDaySalesRequestVo
     * @param sysAccountPo
     * @return
     */
    ResponseData<String> activityDaySalesExport(ActivityDaySalesRequestVo activityDaySalesRequestVo, SysAccountPO sysAccountPo);


    /**
     * 会员画像数据导出
     * @param activityCommonRequestVo
     * @param sysAccountPo
     * @return
     */
    ResponseData<String> activityAgeGenderExport(ActivityCommonRequestVo activityCommonRequestVo, SysAccountPO sysAccountPo);

    /**
     * 会员消费金额分布数据导出
     * @param activityCommonRequestVo
     * @param sysAccountPo
     * @return
     */
    ResponseData<String> activitySalesDistribution(ActivityCommonRequestVo activityCommonRequestVo, SysAccountPO sysAccountPo);
}