package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.bo.ActivityBO;
import com.bizvane.mktcenterservice.models.vo.ActivityVO;
import com.bizvane.mktcenterservice.models.vo.MemberInfoModelVOActivity;
import com.bizvane.mktcenterservice.models.vo.MktActivityPayVo;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author: lijunwei
 * @Time: 2019/5/30 12:58
 */
@FeignClient(value = "${feign.client.mktcenter.name}", path = "${feign.client.mktcenter.path}/activityPayRpc")
public interface ActivityPayServiceRpc {
    @RequestMapping("judgeIsOrNoActiviryPay")
    public ResponseData<Boolean> judgeIsOrNoActiviryPay(@RequestParam Long sysBrandId);

    @RequestMapping("excuseActivityPay")
    public ResponseData excuseActivityPay(@RequestBody MemberInfoModelVOActivity vo);

    @RequestMapping("selectActivityBrandList")
    public ResponseData<PageInfo<ActivityBO>> selectActivityBrandList(@RequestBody MktActivityPayVo activityVO);

    @RequestMapping("judgeStorageGift")
    public ResponseData<List<String>> judgeStorageGift(@RequestParam("brandId") Long brandId, @RequestParam("companyId") Long companyId,
                                                       @RequestParam("storageGiftId") String storageGiftId);
}
