package com.bizvane.mktcenterservice.models.newmkt;

import lombok.*;

import java.io.Serializable;

/**
 * @author Ljc
 */

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MktMemActivityCouponVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 券定义id
     */
    private String couponId;

    /**
     * 券定义名称
     */
    private String couponName;

    /**
     * 券类型
     */
    private String couponType;

    /**
     * 折扣值
     */
    private String discount;

    /**
     * 现金值
     */
    private String money;

    /**
     * 有效天
     */
    private String validDay;

    /**
     * 渠道限制（1仅线下，2全渠道，3仅线上，4员工券，5天猫券）
     */
    private String useChannel;

    /**
     * 有效期开始时间
     */
    private String validDateStart;

    /**
     * 有效期结束时间
     */
    private String validDateEnd;

    /**
     * 自定义券背景图
     */
    private String couponBackGroundUrl;

    /**
     * 优惠类型（1现金，2折扣，3兑换）
     */
    private String preferentialType;

    /**
     * 有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天
     */
    private String validType;

}
