package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @description: 活动分析responseVo
 * @author: Liu Xinpeng
 * @create: 2020-08-10 14:12
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ActivityAnalysisResponseVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 累计参加人数
     */
    private String activitiesPeoNum;

    /**
     * 券发放总数量
     */
    private String vouNum;

    /**
     * 积分发放总数量
     */
    private String bonusPoints;

    /**
     * 券核销数量
     */
    private String verificationVonNum;

    /**
     * 券收益
     */
    private String vouAmount;

    /**
     * 券核销率
     */
    private String verificationVouRate;
}