package com.bizvane.mktcenterservice.interfaces.newmkt;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.mktcenterservice.models.newmkt.ActivitySendMessage;
import com.bizvane.mktcenterservice.models.newmkt.MktMessageNewPo;
import com.bizvane.mktcenterservice.models.newmkt.SimpleMessage;
import com.bizvane.mktcenterservice.models.po.MktMessagePO;
import com.bizvane.mktcenterservice.models.vo.ActivityVO;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * @program: mktcenter-parent
 * @description: 发送短信、微信消息
 * @author: Liu Xinpeng
 * @create: 2020-08-14 16:16
 **/
public interface ActivitySendMessageService {


    /**
     * 新增消息或短信
     *
     * @param activitySendMessage
     * @return
     */
    ResponseData<List<MktMessagePO>> addActivityMessageListTask(ActivitySendMessage activitySendMessage);


    /**
     * 发送微信
     * @param messageVOList
     * @param memberInfo
     * @param simpleMessage
     */
     void sendMessageWX(List<MktMessagePO> messageVOList, MemberInfoModel memberInfo, SimpleMessage simpleMessage);

    /**
     * 发送短信
     * @param messageVOList
     * @param memberInfo
     * @param simpleMessage
     */
     void sendMessageDX(List<MktMessagePO> messageVOList, MemberInfoModel memberInfo, SimpleMessage simpleMessage);

}