package com.bizvane.mktcenterservice.interfaces.newmkt;

import com.bizvane.mktcenterservice.models.dto.OrderDto;
import com.bizvane.mktcenterservice.models.newmkt.ActivityCheckRulesRequestVO;
import com.bizvane.mktcenterservice.models.newmkt.MktMemActivityResponseVO;
import com.bizvane.mktcenterservice.models.newmkt.MktMemActivityVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

/**
 * @author ljc
 * @date on 2020/8/4 11:28
 */
public interface ActivityMemberOrderService {

    /**
     * 消费活动保存
     * @param vo
     * @param sysAccountPo
     * @return
     */
    ResponseData<MktMemActivityResponseVO> saveActivityOrder(MktMemActivityVO vo, SysAccountPO sysAccountPo);

    /**
     * 消费活动修改
     * @param vo
     * @param sysAccountPo
     * @return
     */
    ResponseData<MktMemActivityResponseVO> updateActivityOrder(MktMemActivityVO vo, SysAccountPO sysAccountPo);

    /**
     * 消费订单推送
     * @param orderDto
     * @return
     */
    ResponseData pushOrder(OrderDto orderDto);

    /**
     * 校验订单规则写mq
     * @param checkRulesJson
     * @return
     */
    Boolean sendCheckOrderRules(String checkRulesJson);

    /**
     * 校验订单规则实现
     * @param vo
     */
    void checkOrderRulesConsumer(ActivityCheckRulesRequestVO vo);
}
