package com.bizvane.mktcenterservice.interfaces.newmkt;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.mktcenterservice.models.newmkt.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

/**
 * @program: mktcenter-parent
 * @description:
 * @author: Liu Xinpeng
 * @create: 2020-08-07 19:53
 **/
public interface ActivityAnalyzeService {

    /**
     * 营销活动报表-查询活动分析列表
     * @param requestVo 请求信息
     * @param sysAccountPo
     * @return
     */
    ResponseData<PageInfo<ActivityAnalyzePageResponseVo>> getActivityAnalyzeList(ActivityAnalyzePageRequestVo requestVo, SysAccountPO sysAccountPo);


    /**
     * 营销活动报表-查询活动分析
     * @param activityCommonRequestVo  活动编号
     * @param sysAccountPo
     * @return
     */
    ResponseData<ActivityAnalysisResponseVo> getActivityAnalysis(ActivityCommonRequestVo activityCommonRequestVo, SysAccountPO sysAccountPo);

    /**
     * 营销活动报表
     * @param activityDaySalesRequestVo
     * @param sysAccountPo
     * @return
     */
    ResponseData<JSONObject> getActivityDaySalesAnalysis(ActivityDaySalesRequestVo activityDaySalesRequestVo, SysAccountPO sysAccountPo);
    /**
     * 营销活动报表-查询活动月业绩分析
     * @param activityCommonRequestVo
     * @param sysAccountPo
     * @return
     */
    ResponseData<ActivityMonthSalesResponseVo> getActivityMonthSales(ActivityCommonRequestVo activityCommonRequestVo, SysAccountPO sysAccountPo);

    /**
     * 营销活动报表-查询会员画像性别占比分析
     * @param activityCommonRequestVo
     * @param sysAccountPo
     * @return
     */
    ResponseData<MemberPortraitGenderVo> getMemberPortraitGender(ActivityCommonRequestVo activityCommonRequestVo, SysAccountPO sysAccountPo);


    /**
     * 营销活动报表-查询年龄分布
     * @param activityCommonRequestVo
     * @param sysAccountPo
     * @return
     */
    ResponseData<MemberPortraitAgeVo> getMemberPortraitAge(ActivityCommonRequestVo activityCommonRequestVo, SysAccountPO sysAccountPo);

    /**
     * 营销活动报表-查询会员消费金额分布
     * @param activityCommonRequestVo
     * @param sysAccountPo
     * @return
     */
    ResponseData<MemberSalesDistribution> getMemberSalesDistribution(ActivityCommonRequestVo activityCommonRequestVo, SysAccountPO sysAccountPo);
}
