package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.bo.MktAutoTaskDetailBo;
import com.bizvane.mktcenterservice.models.bo.MktAutoTaskListBo;
import com.bizvane.mktcenterservice.models.bo.MktaAutoTaskDefInfoBo;
import com.bizvane.mktcenterservice.models.dto.MktAutoTaskRecordDetailDto;
import com.bizvane.mktcenterservice.models.vo.MktAutoTaskDefVO;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import java.util.List;


/**
 * @author lipeng
 */
public interface MktAutoTaskDefService {



    /**
     * 保存自动营销任务配置
     * @param vo 任务配置基本信息
     * @return
     */
    public ResponseData<Integer>  addAutoTaskDef(MktAutoTaskDefVO vo, SysAccountPO sysAccountPO);

    /**
     * 查询任务列表
     * @param vo
     * @return
     */
    public ResponseData<MktAutoTaskListBo> selectAutoTaskList(MktAutoTaskDefVO vo, PageForm pageForm);

    /**
     * 查询任务配置信息
     * @param vo
     * @return
     */
    ResponseData<MktaAutoTaskDefInfoBo> selectAutoTaskDefInfo(MktAutoTaskDefVO vo,SysAccountPO sysAccountPO);

    /**
     * 查询任务详详情
     * @param vo
     * @return
     */
    ResponseData<PageInfo<MktAutoTaskDetailBo>> selectAutoTaskDetail(MktAutoTaskDefVO vo, PageForm pageForm);

    /**
     * 任务详情导出
     * @param vo
     * @return
     */
    ResponseData<String> autoTaskDetailExport(MktAutoTaskDefVO vo,SysAccountPO sysAccountPO);

    /**
     * 修改任务
     * @param vo
     * @param stageUser
     * @return
     */
    ResponseData<Integer> updateAutoTaskDef(MktAutoTaskDefVO vo, SysAccountPO stageUser);

    /**
     * 暂停任务
     * @param vo
     * @return
     */
    ResponseData<Integer> pauseAutoTaskJob(MktAutoTaskDefVO vo);
}
