package com.bizvane.mktcenterservice.models.newmkt;

import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * @author Ljc
 */

@Data
@ToString
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MktMemActivityRulesVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 满元或满件,money:满元
     */
    private String type;

    /**
     * 订单来源：多选，以逗号拼接 全部:* 线下订单:1,微商城订单:2
     */
    private String orderFrom;

    /**
     * 会员信息
     */
    private MktMemActivityGroupVO mbrGroup;

    /**
     * 店铺信息
     */
    private MktMemActivityGroupVO storeGroup;

    /**
     * 商品信息
     */
    private MktMemActivityGroupVO itemGroup;

    /**
     * 奖励金额范围
     */
    private List<MktMemActivityOrderRulesVO> orderRules;
}
