package com.bizvane.mktcenterservice.models.newmkt;

import lombok.*;

import java.io.Serializable;

/**
 * @author Ljc
 */

@Data
@ToString
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ActivityPageRequestVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer pageNo;

    private Integer pageSize;

    /**
     * 活动名称
     */
    private String taskName;
    /**
     * 活动编号
     */
    private String taskCode;
    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 开始时间 yyyy-MM-dd HH:mm:ss
     */
    private String startTime;

    /**
     * 结束时间 yyyy-MM-dd HH:mm:ss
     */
    private String endTime;

    /**
     * 活动状态
     */
    private String status;

    /**
     * 审核状态
     */
    private String auditingStatus;

}
