package com.bizvane.mktcenterservice.models.bo;

import com.bizvane.mktcenterservice.models.po.MktActivityPrizeCouponLinkPO;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import lombok.Data;

import java.util.Date;

/**
 * @author yuantq
 * @date 2022/5/29
 */
@Data
public class MktActivityPrizeRecordBO extends MktActivityPrizeRecordPO {

    private String imageUrl;

    /**
     * 实物兑奖剩余时间(提货期限)
     */
    private Integer entityExchangeDay;

    /**
     * 奖品状态(0.未填写提货方式及信息,1.已填写提货方式及信息,2.已提货,3.已过期)
     */
    private Integer entityPriceStatus;

    /**
     * 提货时间限制是否开启	0.关闭(无限制) 1.开启(有限制)
     */
    private Integer pickUpTimeSwitch;

    /**
     * 提货开始时间
     */
    private Date pickUpBeginTime;

    /**
     * 提货结束时间
     */
    private Date pickUpEndTime;

    private Boolean isReturnPoints;

    private MktActivityPrizeCouponLinkPO couponLinkPO;

}
