package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.dto.ChannelRecordInfoDto;
import com.bizvane.mktcenterservice.models.po.MktChannelConfigPo;
import com.bizvane.mktcenterservice.models.po.MktContentChannelSourceActionPo;
import com.bizvane.mktcenterservice.models.vo.ChannelRecordInfoRequestVO;
import com.bizvane.mktcenterservice.models.vo.MemberChannelSourceDetailVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;

import java.util.List;

public interface MemberSourceService {

    /**
     * 查询 会员特定动作/事件 的来源信息
     * @param sysBrandId 品牌id
     * @param memberCode 会员编号
     * @param actionTypes 会员的动作/事件类型：1.浏览，2.注册，3绑定，4点亮俱乐部
     * @return
     */
    MktContentChannelSourceActionPo getMembersSourceByMemberCodeAndActionType(Long sysBrandId, String memberCode, Integer[] actionTypes);

    /**
     * 分页查询 会员渠道记录明细
     * @param requestVo
     * @return
     */
    ResponseData<PageInfo<MktContentChannelSourceActionPo>> getMemberAllSourceActionInfo(MemberChannelSourceDetailVO requestVo);

    /**
     * 查询 渠道记录 详情信息
     * @param requestVo
     * @return
     */
    ResponseData<ChannelRecordInfoDto> getChannelRecordInfo(ChannelRecordInfoRequestVO requestVo);

    /**
     * 根据内容Id 获取 投放渠道列表
     *
     * @param mktContentId    内容Id
     * @param sysBrandId      品牌Id
     * @return
     */
    ResponseData<List<MktChannelConfigPo>> getChannelConfigInfoByMktContentId(Long mktContentId, Long sysBrandId, Long sysCompanyId);

    /**
     * 根据品牌 获取 投放渠道列表
     *
     * @param sysBrandId      品牌Id  俱乐部选择类型为 1 时传当前中台的品牌的Id，为 2时传指定品牌的ID
     * @param selectBrandType 俱乐部选择类型  1-全部 2-指定品牌
     * @return
     */
    ResponseData<List<MktChannelConfigPo>> getChannelConfigInfoByBrandIdAndSelectBrandType(Long sysBrandId, Integer selectBrandType, Long sysCompanyId);
}
