package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.bo.ActivityPrizePickUpBO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizePickUpVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(value = "${feign.client.mktcenter.name}", path = "${feign.client.mktcenter.path}/activityPrize/record")
public interface ActivityPriceRecordNewServiceRpc {

    @RequestMapping("/getActivityPrizeRecordDetail")
    ResponseData<ActivityPrizePickUpBO> getActivityPrizeRecordDetail(@RequestBody ActivityPrizePickUpVO activityPrizePickUpVO);

    @RequestMapping("/confirmPickUp")
    ResponseData confirmPickUp(@RequestBody ActivityPrizePickUpVO activityPrizePickUpVO);

    @RequestMapping("/selectPickUpList")
    ResponseData<PageInfo<ActivityPrizePickUpBO>> selectPickUpList(@RequestBody ActivityPrizePickUpVO activityPrizePickUpVO);


}
