package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vg.VGContentChannelRequestVo;
import com.bizvane.mktcenterservice.models.vg.VGContentChannelResponseVo;
import com.bizvane.mktcenterservice.models.vg.VGContentVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @Author: lijunwei
 * @Time: 2019/4/8 18:19
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/content")
public interface ContentServiceRpc {
    /**
     * 新增  收货地址
     */
    @PostMapping("pv")
    public void pv(@RequestBody VGContentVo vo);

    @ApiOperation("集团卡开卡时调用此接口记录")
    @PostMapping("openOrBindCard")
    public void openOrBindCard(@RequestBody VGContentVo vo);

    @ApiOperation("俱乐部入会/点亮俱乐部时调用此接口记录")
    @PostMapping("joinClub")
    public void joinClub(@RequestBody VGContentVo vo);

    @ApiOperation("验证渠道有效性")
    @PostMapping("verifyChannel")
    public ResponseData<Boolean> verifyChannel(@RequestBody VGContentVo vo);

    @PostMapping("getChannel")
    public ResponseData<VGContentChannelResponseVo> getChannel(@RequestBody VGContentChannelRequestVo vo);
}
